import numpy as np 
import sys
import os 
import random 
from Options import *
from Utility import  Draw_SyntheticData_Results, GetDirectory, PlotEffectSizeAlongLabels, PlotResultsAlongBudgets, PlotTypeIAlongBudgets, plot_acc_passive_and_active 
sys.path.append(os.getcwd() + "/CreateDataset/")
sys.path.append(os.getcwd() + "/ClassifierTwoSample/")



def main():

    """
    Set up parameters
    """
    args = parser.parse_args()
    print('========================= Performing a %s Two-sample Test with %s query scheme, Sep: %.2f, noise: %.2f, budget: %d =============================='%(args.TestType, args.QS, args.Sep, args.noise_var, args.Budget))
    random.seed(args.Trial); 
    np.random.seed(args.Trial)

    """
    Bulid directory
    """
    print('========================= Build directory ==============================')
    StatsPath, FigurePath = GetDirectory(args)

    """
    Draw synthetic data and queried point 
    """
    if args.Draw_SyntheticData_Results:
        Draw_SyntheticData_Results(args, FigurePath)

    """
    Plot Type I errors for various settings
    """
    if args.Plot_TypeI == 1:
        PlotTypeIAlongBudgets(args, FigurePath)

    """
    Comparing active to passive methods along various label budget
    """
    if args.print_results_alongbudgets == 1:
        PlotResultsAlongBudgets(args)

    """
    Acquire the effect size as a function of labels spents
    """
    if args.print_effectsize_alonglabels == 1:
        PlotEffectSizeAlongLabels(args, FigurePath)

    """
    Obtain the acc for the passive and active learning 
    """
    if args.print_acc == 1:
        plot_acc_passive_and_active(args, FigurePath)

if __name__ == '__main__':
	main()